/*
  Game provider settings class for Bombing Run game.
  Unfortunately ut doesn't give us any proper means for setting these settings
  programatically so we have to recreate this class here in the br package,
  make the strings unlocalized and set the config area to BombingRun, and then
  we are allowed to write to this ini section as we wish.
  
  
  Author Mark Caldwell aka W@rHe@d of The Reliquary
*/
class UTUIDataProvider_GameModeInfo extends UTUIResourceDataProvider PerObjectConfig config(BombingRun);

// (cpptext)
// (cpptext)
// (cpptext)
// (cpptext)
// (cpptext)

/** full path to the game class */
var config string GameMode;

/** The map that this game mode defaults to */
var config string DefaultMap;

/** Settings class to use for this game mode. */
var config string GameSettingsClass;

/** Search class to use for this game mode. */
var config string GameSearchClass;

/** Option set to use for the game mode. */
var config string OptionSet;

/** Friendly displayable name to the player. */
var config string FriendlyName;

/** Localized description of the game mode */
var config string Description;

/** Markup text used to display the preview image for the game mode. */
var config string PreviewImageMarkup;

/** Prefixes of the maps this gametype supports. */
var config string Prefixes;

/** Image that the icon of this game mode is on. */
var config string IconImage;

/** Whether or not this a campaign game mode. */
var config bool bIsCampaign;

/** UV Coordinates for the icon. */
var config float IconU;
var config float IconV;
var config float IconUL;
var config float IconVL;

// Allows mods to specify a custom scene for configuring mod settings;
//	accessible through the 'Mod Settings' button in the Instant Action and Host Game menus
var config string ModGameSettingsScene;

// As above, but this scene is made accessible through the main menu settings page, and the mid game menu settings
var config string ModClientSettingsScene;

defaultproperties
{
   bSearchAllInis=True
   Name="Default__UTUIDataProvider_GameModeInfo"
   ObjectArchetype=UTUIResourceDataProvider'UTGame.Default__UTUIResourceDataProvider'
}
